IF OBJECT_ID('P_REPROCESSAR_PDV_VD_IT_PRODUTO_CADASTRO') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_REPROCESSAR_PDV_VD_IT_PRODUTO_CADASTRO
	END 
GO
--exec P_REPROCESSAR_PDV_VD_IT_PRODUTO_CADASTRO 4,2012
CREATE PROCEDURE [dbo].[P_REPROCESSAR_PDV_VD_IT_PRODUTO_CADASTRO]( @MES INT=NULL, @ANO INT=NULL,@CD_FILIAL_PAR INT=0)  AS
	
	DECLARE @DT_INI DATETIME
	DECLARE @DT_FIM DATETIME
	DECLARE @DIA DATETIME
	DECLARE @CD_FILIAL AS INT
	DECLARE @AGORA DATETIME
	
	SET NOCOUNT ON
	IF @ANO IS NULL OR @MES IS NULL
		begin
			SELECT @AGORA=DATEADD(month, -1, GETDATE()), @ANO=YEAR(@AGORA), @MES=MONTH(@AGORA)
		end
	
	SET @DT_INI = CONVERT(DATETIME, (CONVERT(VARCHAR, (@ANO*100+@MES)) + '01')) ;
	SET @DT_FIM = dbo.F_FINAL_MES (@DT_INI) ;
	
	--RODA SO ATE ONTEM
	IF  @DT_FIM > dbo.F_HOJE()
	BEGIN
		SET @DT_FIM = dbo.F_HOJE() -1 
	END
	
	DECLARE cFilial CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT  
	 	CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE 
		CD_EMP = 1  
		AND CD_FILIAL = CASE WHEN @CD_FILIAL_PAR = 0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
	OPEN CFILIAL
	FETCH NEXT FROM cFilial INTO @CD_FILIAL

	WHILE @@FETCH_STATUS=0
	BEGIN
		SET @DIA = @DT_INI
		WHILE @DT_FIM >= @DIA
			BEGIN

				PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' -  Processando dia  ' + CONVERT(VARCHAR, @DIA, 112) + ' ' + CONVERT(VARCHAR, GETDATE (),108)

				UPDATE 
					PDV_VD_IT
				SET
					PIS_COFINS				=	p.PIS_COFINS,
					LISTA_PROD				=	p.LISTA_PROD
				FROM
					PDV_VD INNER JOIN PDV_VD_IT ON
					PDV_VD.CD_EMP  = PDV_VD_IT.CD_EMP AND
					PDV_VD.CD_FILIAL = PDV_VD_IT.CD_FILIAL AND
					PDV_VD.CD_VD = PDV_VD_IT.CD_VD 
					INNER JOIN EST_PROD p ON 
					PDV_VD_IT.CD_EMP = p.CD_EMP AND 
					PDV_VD_IT.CD_PROD = p.CD_PROD
				WHERE
					PDV_VD.CD_EMP = 1 
					AND PDV_VD.CD_FILIAL = @CD_FILIAL 
					AND PDV_VD.DT_VD = @DIA
				
				SELECT @DIA = @DIA + 1
			END		
		FETCH NEXT FROM  cFilial INTO @CD_FILIAL 
	END
CLOSE cFilial
DEALLOCATE cFilial

